extends Node2D

var checkingversion = false
var game = 0
var versionurl: = "https://barfysadventure.nfshost.com/version.txt"
var game_url: = "https://barfysadventure.nfshost.com/pck/index.pck"
var launcher_url: = "https://barfysadventure.nfshost.com/pck/launcher.pck"
var audio_url: = "https://barfysadventure.nfshost.com/pck/songs.pck"
var offset: = Vector2(725, 348)
var updating: = false
var newest_game_version: = ""
var newest_launcher_version: = ""
var newest_audio_version: = ""
var versiondata = {}
var versiondatanew = {}
var launcher_version = "1.7"
var downloading_game = false
var downloading_launcher = false
var downloading_audio = false
var score = 0
var headers = ["Cache-Control: no-cache"]
var settings = false
var rp_part = 1
var platform = ""
var audioupdate = false
var steam = false
var storylevels = {
	-1: {
		"location": Vector2i(22, 7), 
		"name": "What Chamber 1", 
		"path": "1_1", 
		"type": "main", 
		"difficulty": 1, 
		"thumbnail": 1, 
		"icon": "res://assets/icons/ground.png", 
		"icon_offset": 0, 
		"world": 1, 
	}, 
	-2: {
		"location": Vector2i(17, 10), 
		"name": "What Chamber 2", 
		"path": "1_2", 
		"type": "main", 
		"difficulty": 2, 
		"thumbnail": 2, 
		"icon": "res://assets/enemy/whatamiicon2.png", 
		"icon_offset": 0, 
		"world": 1, 
	}, 
	-3: {
		"location": Vector2i(12, 2), 
		"name": "Who\'s Pyramid", 
		"path": "1_3", 
		"type": "main", 
		"difficulty": 2, 
		"thumbnail": 3, 
		"icon": "res://assets/enemy/whoareyouicon.png", 
		"icon_offset": 0, 
		"world": 1, 
	}, 
	-4: {
		"location": Vector2i(12, -8), 
		"name": "Groundbreaking", 
		"path": "1_4", 
		"type": "main", 
		"difficulty": 3, 
		"thumbnail": 4, 
		"icon": "res://assets/tiles/ball.png", 
		"icon_offset": -1, 
		"world": 1, 
	}, 
	-10001: {
		"location": Vector2i(18, 2), 
		"name": "Jump, Fall, Bounce!", 
		"path": "bt1", 
		"type": "bt", 
		"difficulty": 1, 
		"thumbnail": 5, 
		"icon": "res://assets/tiles/springicon.png", 
		"icon_offset": -1, 
		"world": 1, 
	}, 
	-10002: {
		"location": Vector2i(22, -11), 
		"name": "Dash Destroyer", 
		"path": "bt2", 
		"type": "bt", 
		"difficulty": 1, 
		"thumbnail": 6, 
		"icon": "res://assets/tiles/dashgate.png", 
		"icon_offset": 15, 
		"world": 1, 
	}, 
	-20001: {
		"location": Vector2i(26, -8), 
		"name": "Meet Wooey", 
		"path": "wooey", 
		"type": "boss", 
		"difficulty": 3, 
		"thumbnail": 7, 
		"icon": "res://assets/hat/icons/10.png", 
		"icon_offset": -1, 
		"world": 1, 
	}, 
	-30001: {
		"location": Vector2i(29, -8), 
		"name": "Going Up", 
		"path": "t1", 
		"type": "transition", 
		"difficulty": 2, 
		"thumbnail": 8, 
		"icon": "res://assets/ui/pixelicons/up.png", 
		"icon_offset": 0, 
		"world": 1, 
	}, 
	-5: {
		"location": Vector2i(29, -43), 
		"name": "Intruder Alert", 
		"path": "2_1", 
		"type": "main", 
		"difficulty": 3, 
		"thumbnail": 9, 
		"icon": "res://assets/tiles/orb/1.png", 
		"icon_offset": 0, 
		"world": 2, 
	}, 
	-6: {
		"location": Vector2i(47, -43), 
		"name": "Operation ON-OFF", 
		"path": "2_2", 
		"type": "main", 
		"difficulty": 3, 
		"thumbnail": 10, 
		"icon": "res://assets/tiles/onblockicon.png", 
		"icon_offset": 0, 
		"world": 2, 
	}, 
	-10003: {
		"location": Vector2i(38, -48), 
		"name": "Dash Constructor", 
		"path": "bt3", 
		"type": "bt", 
		"difficulty": 1, 
		"thumbnail": 12, 
		"icon": "res://assets/tiles/dashspringicon.png", 
		"icon_offset": -1, 
		"world": 2, 
	}, 
	-100007: {
		"location": Vector2i(56, -35), 
		"name": "Amethyst Tunnel", 
		"path": "2_3n", 
		"type": "main", 
		"difficulty": 2, 
		"thumbnail": 11, 
		"icon": "res://assets/enemy/opticoneicon.png", 
		"icon_offset": -1, 
		"world": 2, 
	}, 
	-7: {
		"location": Vector2i(56, -35), 
		"name": "Amethyst Hollow", 
		"path": "2_3", 
		"type": "secret", 
		"difficulty": 3, 
		"thumbnail": 24, 
		"icon": "res://assets/enemy/opticoneicon.png", 
		"icon_offset": -1, 
		"world": 2, 
	}, 
	-10004: {
		"location": Vector2i(68, -35), 
		"name": "Hurry Up!", 
		"path": "bt4", 
		"type": "bt", 
		"difficulty": 0, 
		"thumbnail": 15, 
		"icon": "res://assets/tiles/conveyoricon.png", 
		"icon_offset": 0, 
		"world": 2, 
	}, 
	-8: {
		"location": Vector2i(68, -45), 
		"name": "pingWrap", 
		"path": "2_4", 
		"type": "main", 
		"difficulty": 3, 
		"thumbnail": 13, 
		"icon": "res://assets/tiles/camerawrap.png", 
		"icon_offset": 0, 
		"world": 2, 
	}, 
	-40001: {
		"location": Vector2i(-6, 10), 
		"name": "What Chamber 3", 
		"path": "1_s", 
		"type": "secret", 
		"difficulty": 3, 
		"thumbnail": 14, 
		"icon": "res://assets/enemy/boulder/bouldericon.png", 
		"icon_offset": -1, 
		"world": 1, 
	}, 
	-40002: {
		"location": Vector2i(-600, 10), 
		"name": "10 Sleepy Seconds", 
		"path": "2_s", 
		"type": "secret", 
		"difficulty": 5, 
		"thumbnail": 22, 
		"icon": "res://assets/enemy/zeteor/zeteoricon.png", 
		"icon_offset": -1, 
		"world": 2, 
	}, 
	-99999: {
		"location": Vector2i(22, 5), 
		"name": "Cutscene", 
		"path": "1", 
		"type": "cutscene", 
		"cutscene_id": 1, 
		"difficulty": 0, 
		"thumbnail": 200, 
		"icon": "", 
		"icon_offset": 0, 
		"world": 1, 
	}, 
	-999991: {
		"location": Vector2i(29, -37), 
		"name": "Cutscene", 
		"path": "2", 
		"type": "cutscene", 
		"cutscene_id": 2, 
		"difficulty": 0, 
		"thumbnail": 16, 
		"icon": "", 
		"icon_offset": 0, 
		"world": 2, 
	}, 
	-999992: {
		"location": Vector2i(79, -13), 
		"name": "Cutscene", 
		"path": "3", 
		"type": "cutscene", 
		"cutscene_id": 3, 
		"difficulty": 0, 
		"thumbnail": 16, 
		"icon": "", 
		"icon_offset": 0, 
		"world": 3, 
	}, 
	-20002: {
		"location": Vector2i(79, -45), 
		"name": "Going Down", 
		"path": "liquify", 
		"type": "boss", 
		"difficulty": 4, 
		"thumbnail": 17, 
		"icon": "res://assets/hat/icons/34.png", 
		"icon_offset": -1, 
		"world": 2, 
	}, 
	-9: {
		"location": Vector2i(91, -13), 
		"name": "Jump-start Jungle", 
		"path": "3_1", 
		"type": "main", 
		"difficulty": 3, 
		"thumbnail": 18, 
		"icon": "res://assets/tiles/balloonicon.png", 
		"icon_offset": -1, 
		"world": 3, 
	}, 
	-10: {
		"location": Vector2i(91, 3), 
		"name": "🍄🍄🍄🍄🍄🍄", 
		"path": "3_2", 
		"type": "main", 
		"difficulty": 3, 
		"thumbnail": 20, 
		"icon": "res://assets/tiles/mushroomicon.png", 
		"icon_offset": 0, 
		"world": 3, 
	}, 
	-10005: {
		"location": Vector2i(91, -5), 
		"name": "Target Practice", 
		"path": "bt5", 
		"type": "bt", 
		"difficulty": 2, 
		"thumbnail": 19, 
		"icon": "res://assets/tiles/targeticon.png", 
		"icon_offset": -1, 
		"world": 3, 
	}, 
	-11: {
		"location": Vector2i(73, 3), 
		"name": "Stored Away", 
		"path": "3_3", 
		"type": "main", 
		"difficulty": 3, 
		"thumbnail": 21, 
		"icon": "res://assets/tiles/clockicon.png", 
		"icon_offset": 0, 
		"world": 3, 
	}, 
	-12: {
		"location": Vector2i(73, 3), 
		"name": "On the Bubble", 
		"path": "3_4", 
		"type": "main", 
		"difficulty": 3, 
		"thumbnail": 25, 
		"icon": "res://assets/tiles/diagonalbubblearrow.png", 
		"icon_offset": -1, 
		"world": 3, 
	}, 


}


func _ready() -> void :

	if FileAccess.file_exists("user://settings.txt"):
		var file = FileAccess.open("user://settings.txt", FileAccess.READ)
		var settings = JSON.parse_string(file.get_as_text())
		if settings.has("bgm"):
			AudioServer.set_bus_volume_db(1, linear_to_db(settings["bgm"]))
			AudioServer.set_bus_volume_db(2, linear_to_db(settings["sfx"]))
			AudioServer.set_bus_volume_db(0, linear_to_db(settings["master"]))
		if settings.has("disablelaunchermusic"):
			if settings["disablelaunchermusic"] == 1:
				$Launcher.stop()

	headers = []
	if steam:
		$SettingsPanel / Settings.visible = false
	choose_bg()

	DisplayServer.window_set_title("Barfy\'s Adventure Launcher")
	platform = OS.get_name()
	if platform != "Windows":
		$Game.visible = false
		$Downloading.position.y += 50
		$Downloading2.position.y += 50
	if ["Android", "macOS", "Web"].has(platform):
		$SettingsPanel / Buttons / RichPresence.visible = false
	if ["Android", "Web"].has(platform):
		$SocialMedia / Folder.visible = false
	$SettingsPanel / Location.text = OS.get_user_data_dir()
	if FileAccess.file_exists("user://version.json"):
		versiondata = {
			"game": "none", 
			"launcher": launcher_version, 
			"audio": "none", 
		}
		var file = FileAccess.open("user://version.json", FileAccess.READ)
		versiondatanew = JSON.parse_string(file.get_as_text())
		versiondata.merge(versiondatanew, true)

	else:
		versiondata = {
			"game": "none", 
			"launcher": launcher_version, 
			"audio": "none", 
		}
	versiondata["launcher"] = launcher_version
	refresh()
func _physics_process(delta: float) -> void :
	if settings:
		$SettingsPanel.position.x = lerp($SettingsPanel.position.x, 1041.0, 0.2)
	else:
		$SettingsPanel.position.x = lerp($SettingsPanel.position.x, 1284.0, 0.2)





	if downloading_game:
		$Downloading.text = str(snapped($DownloadGame.get_downloaded_bytes() / 1000000.0, 0.1), " MB downloaded")
	elif downloading_launcher:
		$Downloading2.text = str(snapped($DownloadLauncher.get_downloaded_bytes() / 1000000.0, 0.1), " MB downloaded")
	elif downloading_audio:
		$Downloading3.text = str(snapped($DownloadAudio.get_downloaded_bytes() / 1000000.0, 0.1), " MB downloaded")
	if downloading_game or downloading_audio:
		settings = false
		$BG.modulate = lerp($BG.modulate, Color(0.3, 0.3, 0.3), 0.2)
		$Score.visible = true
		$Score.text = str("Score: ", score)
	else:
		$BG.modulate = lerp($BG.modulate, Color(1, 1, 1), 0.2)
	if updating:
		$SettingsPanel / Settings.modulate = Color(0.25, 0.25, 0.25)
		$Game.modulate = Color(0.25, 0.25, 0.25)
		$Play.modulate = Color(0.25, 0.25, 0.25)
		$UpdateButtons.modulate = Color(0.25, 0.25, 0.25)
	else:
		$Game.modulate = Color(1, 1, 1)
		$Play.modulate = Color(1, 1, 1)
		$SettingsPanel / Settings.modulate = Color(1, 1, 1)
		$UpdateButtons.modulate = Color(1, 1, 1)
	$BG.position.x = lerp($BG.position.x, get_global_mouse_position().x / 20 + offset.x, 0.2)
	$BG.position.y = lerp($BG.position.y, get_global_mouse_position().y / 40 + offset.y, 0.2)
	if Input.is_action_just_pressed("click"):
		if $SettingsPanel / Settings.button_pressed:
			if updating == false:
				if settings == false:
					settings = true
					$SettingsPanel / Settings.texture_normal = load("res://assets/ui/pixelicons/right.png")
					$Click.play()
				else:
					settings = false
					$SettingsPanel / Settings.texture_normal = load("res://assets/ui/pixelicons/settings.png")
					$Back.play()
		if $SocialMedia / Website.button_pressed:
			if $SocialMedia / Website.button_pressed:
				$Click.play()
				OS.shell_open("https://www.adventure.barfy.net/")
				$SocialMedia / Website.disabled = true
				$SocialMedia / Website.disabled = false
		if $SocialMedia / Discord.button_pressed:
			if $SocialMedia / Discord.is_hovered():
				$Click.play()
				OS.shell_open("https://discord.gg/vcKxR6Fwnh")
				$SocialMedia / Discord.disabled = true
				$SocialMedia / Discord.disabled = false
		if $SocialMedia / Folder.button_pressed:
			if $SocialMedia / Folder.is_hovered():
				$Click.play()
				OS.shell_open(OS.get_user_data_dir())
				$SocialMedia / Folder.disabled = true
				$SocialMedia / Folder.disabled = false
		elif $Play.button_pressed and updating == false:
			if versiondata["game"] == "none" and game == 0:
				$Error.play()
			else:
				updating = true
				$PlaySound.play()
				var success
				if game == 0:
					success = ProjectSettings.load_resource_pack("user://game.pck")
				elif game == 1:
					success = ProjectSettings.load_resource_pack("bpf.pck")
				if success:

					$Fade2.play("FadeOut")
				else:
					updating = false


		elif $UpdateButtons / UpdateGame.button_pressed and updating == false:
			if audioupdate and steam == false:
				$WAITimer.start()
				$VersionLoading.visible = true
				updating = true
				$Click.play()
				var req = $DownloadAudio
				req.download_file = "user://songs.pck"
				req.request(audio_url, headers, HTTPClient.METHOD_GET)
				downloading_audio = true
			else:
				$Click.play()
				update_game()
		elif $UpdateButtons / UpdateLauncher.button_pressed and updating == false and steam == false:
			if platform == "macOS":
				$Click.play()
				OS.shell_open("https://barfy.itch.io/adventure")
				$UpdateButtons / UpdateLauncher.disabled = true
				$UpdateButtons / UpdateLauncher.disabled = false
			else:
				$WAITimer.start()
				$VersionLoading.visible = true
				updating = true
				$Click.play()
				var req = $DownloadLauncher
				req.download_file = "BarfysAdventure.pck"
				req.request(launcher_url, headers, HTTPClient.METHOD_GET)
				downloading_launcher = true
		elif $UpdateButtons / UpdateAudio.button_pressed and updating == false and steam == false:
			$WAITimer.start()
			$VersionLoading.visible = true
			updating = true
			$Click.play()
			var req = $DownloadAudio
			req.download_file = "user://songs.pck"
			req.request(audio_url, headers, HTTPClient.METHOD_GET)
			downloading_audio = true
		elif $SettingsPanel / Buttons / RichPresence.button_pressed and updating == false:

			$WAITimer.start()
			$VersionLoading.visible = true
			updating = true
			$Click.play()
			var req = $DownloadRP
			var url = "discord_game_sdk.dll"
			if platform == "Windows":
				url = "discord_game_sdk.dll"
			if platform == "Linux":
				url = "libdiscord_game_sdk.so"
			req.download_file = url
			req.request(str("https://barfysadventure.nfshost.com/pck/", url), headers, HTTPClient.METHOD_GET)
			downloading_launcher = true
			rp_part = 1
		if updating == false:
			if $SettingsPanel / Buttons / Delete.button_pressed:
				if checkingversion == false:
					checkingversion = true
					DirAccess.remove_absolute("user://version.json")
					DirAccess.remove_absolute("user://game.pck")
					DirAccess.remove_absolute("game.pck")
					versiondata = {
					"game": "none", 
					"launcher": launcher_version, 
					"audio": "none", 
					}
					refresh()
					get_tree().reload_current_scene()


func _on_get_version_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void :
	checkingversion = false
	if body.get_string_from_utf8() != "":


		newest_game_version = str(body.get_string_from_utf8().split("\n")[0])
		if steam == false:
			newest_launcher_version = str(body.get_string_from_utf8().split("\n")[1])
			newest_audio_version = str(body.get_string_from_utf8().split("\n")[2])
		else:
			newest_launcher_version = launcher_version
			newest_audio_version = versiondata["audio"]
		$VersionLoading.visible = false

		if versiondata["game"] == newest_game_version:
			$Downloading.text = str("Game is up to date")
		else:
			$Downloading.text = str("Game Update Available: ", newest_game_version)
			$UpdateButtons / UpdateGame.visible = true
			$Pop.play()

		if versiondata["launcher"] != newest_launcher_version:
			if steam == false:
				$Downloading2.text = str("Launcher Update Available: ", newest_launcher_version)
				if platform != "Web":
					$UpdateButtons / UpdateLauncher.visible = true
					$Pop.play()

		else:
			$Downloading2.text = str("Launcher is up to date")

		if versiondata["audio"] != newest_audio_version:
			if steam == false:
				$Downloading3.text = str("Audio Update Available: ", newest_audio_version)
				audioupdate = true
				$Pop.play()
				if $UpdateButtons / UpdateGame.visible == false:
					$UpdateButtons / UpdateAudio.visible = true

		else:
			$Downloading3.text = str("Audio is up to date")
		if versiondata["game"] == newest_game_version and versiondata["launcher"] == newest_launcher_version and versiondata["audio"] == newest_audio_version:
			$Everything.visible = true
			$Downloading.visible = false
			$Downloading2.visible = false
			$Downloading3.visible = false
func update_version_number():
	if steam:
		$CurrentVersion.text = str("BA Version: ", versiondata["game"])
	else:
		$CurrentVersion.text = str("Game: ", versiondata["game"], "\nLauncher: ", launcher_version, "\nAudio: ", versiondata["audio"])

func _on_fade_2_animation_finished(anim_name: StringName) -> void :
	if anim_name == "FadeOut":
		if game == 0:
			if get_tree().change_scene_to_file("res://SceneManager.tscn") != OK:
				notify("Error:\nTry resettng the pck and updating again")
				$Fade2.play("RESET")
				updating = false
				settings = true
				$Error.play()
		elif game == 1:
			get_tree().change_scene_to_file("res://title.tscn")
	elif anim_name == "FadeOutLauncher":

		OS.set_restart_on_exit(true)
		get_tree().quit()


func _on_download_game_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void :
	downloading_game = false
	$VersionLoading.visible = false
	$Downloading.text = "Finished Game Update!"
	$UpdateButtons / UpdateGame.visible = false
	$Finish.play()
	updating = false
	versiondata["game"] = newest_game_version
	var file = FileAccess.open("user://version.json", FileAccess.WRITE)
	file.store_string(JSON.stringify(versiondata))
	update_version_number()
	if steam == false:
		DirAccess.remove_absolute("game.pck")
		DirAccess.remove_absolute("songs.pck")


func _on_download_launcher_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void :
	downloading_launcher = false
	$VersionLoading.visible = false
	$Downloading2.text = "Finished Launcher Update!"
	$UpdateButtons / UpdateGame.visible = false
	$Finish.play()
	versiondata["launcher"] = newest_launcher_version
	var file = FileAccess.open("user://version.json", FileAccess.WRITE)
	file.store_string(JSON.stringify(versiondata))
	update_version_number()
	var success = ProjectSettings.load_resource_pack("BarfysAdventure.pck")
	if success:
		$Fade2.play("FadeOutLauncher")


func _on_wai_timer_timeout() -> void :
	if downloading_game or downloading_audio:
		var b = load("res://wai.tscn").instantiate()
		b.position.x = randi_range(300, 1230)
		b.direction = randi_range(0, 1)
		add_child(b)
		$WAITimer.start()


func _on_game_item_selected(index: int) -> void :
	pass








func refresh():
	update_version_number()
	versiondata["launcher"] = launcher_version
	$GetVersion.request(versionurl, headers, HTTPClient.METHOD_GET)
	$VersionLoading.visible = true
	$UpdateButtons / UpdateGame.visible = false
	$UpdateButtons / UpdateLauncher.visible = false
	$UpdateButtons / UpdateAudio.visible = false
	$Downloading.text = ""


func _on_download_rp_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void :
	if rp_part == 1:
		rp_part = 2
		$RP_2.start()
	else:

		downloading_launcher = false
		$VersionLoading.visible = false
		$Downloading2.text = "Finished Rich Presence Download!"
		$UpdateButtons / UpdateGame.visible = false
		$Finish.play()


		var success = ProjectSettings.load_resource_pack("BarfysAdventure.pck")
		if success:
			$Fade2.play("FadeOutLauncher")


func _on_rp_2_timeout() -> void :
	$WAITimer.start()
	$VersionLoading.visible = true
	updating = true
	var req = $DownloadRP
	var url = "discord_game_sdk_binding.dll"
	if platform == "Windows":
		url = "discord_game_sdk_binding.dll"
	if platform == "Linux":
		url = "libdiscord_game_sdk_binding.so"
	req.download_file = url
	req.request(str("https://barfysadventure.nfshost.com/pck/", url), headers, HTTPClient.METHOD_GET)
	downloading_launcher = true


func _on_download_audio_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void :
	downloading_audio = false
	$VersionLoading.visible = false
	$Downloading3.text = "Finished Audio Update!"
	$UpdateButtons / UpdateAudio.visible = false

	versiondata["audio"] = newest_audio_version
	var file = FileAccess.open("user://version.json", FileAccess.WRITE)
	file.store_string(JSON.stringify(versiondata))
	update_version_number()
	if versiondata["game"] != newest_game_version:
		update_game()
	else:
		$Fade2.play("FadeOutLauncher")





func update_game():
	$WAITimer.start()
	$VersionLoading.visible = true
	updating = true

	var req = $DownloadGame
	req.download_file = "user://game.pck"
	req.request(game_url, headers, HTTPClient.METHOD_GET)
	downloading_game = true


func choose_bg():
	var storydata = {}
	if FileAccess.file_exists("user://story.txt"):
		storydata = {
			"-1": 0, 
			"-2": 0, 
			"-3": 0, 
			"-4": 0, 
			"-10001": 0, 
			"-10002": 0, 
			"-20001": 0, 
			"-20002": 0, 
			"-30001": 0, 
			"-40001": 0, 
			"-40002": 0, 
			"-100007": 0, 
			"-5": 0, 
			"-6": 0, 
			"-7": 0, 
			"-8": 0, 
			"-9": 0, 
			"-10": 0, 
			"-11": 0, 
			"-12": 0, 
			"-10005": 0, 
			"-10003": 0, 
			"-10004": 0, 
		}
		var file = FileAccess.open("user://story.txt", FileAccess.READ)
		var storydatanew = JSON.parse_string(file.get_as_text())
		storydata.merge(storydatanew, true)
		var completedlevelids = []
		for i in storydata:
			if storydata[i] == 1:
				if storylevels.has(int(i)):
					completedlevelids.append(int(i))

		var randombg = 1
		if completedlevelids.size() > 0:
			randombg = storylevels[completedlevelids.pick_random()]["thumbnail"]
		if randombg == 0 or randombg == null:
			randombg = 1
		$BG.texture = load(str("res://assets/bg/", randombg, ".png"))

func notify(text):


	if "[notify_bottom]" in str(text):
		text = text.replace("[notify_bottom]", "")
		$Notification / Noficiation.play("NotifyBottom")
		$Notification / Noficiation.seek(0)
	else:
		$Notification / Noficiation.play("Notify")
		$Notification / Noficiation.seek(0)
	$Notification / Panel / Text.text = text
