# modified from https://github.com/Pukkah/HTML5-File-Exchange-for-Godot/blob/master/addons/HTML5FileExchange/HTML5FileExchange.gd

extends Node

signal read_completed;
signal load_completed(filename: String, bytes: PackedByteArray);

var js_callback = JavaScriptBridge.create_callback(read_completed.emit);
var js_interface = null;

func _ready():
	if OS.get_name() == "Web":
		_define_js()
		js_interface = JavaScriptBridge.get_interface("_HTML5FileExchange");
		read_completed.connect(func(args: Array):
			load_completed.emit(
				JavaScriptBridge.eval("_HTML5FileExchange.fileName", true),
				JavaScriptBridge.eval("_HTML5FileExchange.result", true),
			);
		);

func _define_js()->void:
	#Define JS script
	JavaScriptBridge.eval("""
	if (!window._HTML5FileExchange) {
		window._HTML5FileExchange = {};
		window._HTML5FileExchange.upload = function(gd_callback) {
			canceled = true;
			var input = document.createElement('INPUT'); 
			input.setAttribute("type", "file");
			input.click();
			input.addEventListener('change', event => {
				if (event.target.files.length > 0){
					canceled = false;} else {return;}
				var file = event.target.files[0];
				var reader = new FileReader();
				this.fileType = file.type;
				this.fileName = file.name || "file.txt";
				reader.readAsArrayBuffer(file);
				reader.onloadend = (evt) => { // Since here's it's arrow function, "this" still refers to _HTML5FileExchange
					if (evt.target.readyState == FileReader.DONE) {
						this.result = evt.target.result;
						gd_callback(); // ArrayBuffers don't get converted in callbacks so this is just for notification
					}
				}
			  });
		}
	}
	""", true);

func is_available():
	return js_interface != null;

func load_file():
	if OS.get_name() != "Web":
		return;

	js_interface.upload(js_callback);
