extends VBoxContainer

var path: String:
	get: return owner.path;
	set(value): owner.path = value;

@onready var save: Button = $Buttons/Save;
@onready var exit: Button = $Buttons/Exit;
@onready var text_edit: CodeEdit = $TextEdit;
@onready var converted: Label = $Buttons/Converted;
@onready var deconverted: Button = $Buttons/Deconverted;

var is_variant := false:
	set(value):
		is_variant = value;
		text_edit.auto_brace_completion_enabled = is_variant;

func _ready():
	save.pressed.connect(func():
		var formatted;
		if is_variant:
			formatted = str_to_var(text_edit.text);
			print(formatted);
			if formatted == null && text_edit.text.strip_edges() != "null":
				OS.alert("Syntax is invalid. File was not saved.");
				return;
		
		var file := FileAccess.open(path, FileAccess.WRITE);
		if !file:
			OS.alert(error_string(FileAccess.get_open_error()), "Couldn't save file.");
			return;
		
		if is_variant:
			file.store_var(formatted);
		else:
			file.store_string(text_edit.text);
		file.close();
		owner.go_back();
	);
	exit.pressed.connect(owner.go_back);
	
	deconverted.pressed.connect(func():
		deconverted.visible = false;
		converted.visible = true;
		is_variant = true;
	);

func cleanup():
	text_edit.text = "";

func refresh():
	is_variant = path.ends_with(".save");
	deconverted.visible = false;
	if is_variant:
		var text = "";
		var handle := FileAccess.open(path, FileAccess.READ);
		if !handle:
			OS.alert("Could not read .save file.\n" + error_string(FileAccess.get_open_error()));
			owner.go_back();
			return;
		
		var obj = handle.get_var();
		
		handle.seek(0);
		if obj == null && handle.get_buffer(8) != PackedByteArray([4, 0, 0, 0, 0, 0, 0, 0]):
			is_variant = false;
			deconverted.visible = true;
		else:
			text_edit.text = var_to_str(obj);
	if !is_variant:
		text_edit.text = FileAccess.get_file_as_string(path);
	converted.visible = is_variant;
